/*
 * Decompiled with CFR 0.152.
 */
package mcjty.tools.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcjty.tools.cache.StructureCacheEntry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureData;

public class StructureCache {
    public static final StructureCache CACHE = new StructureCache();
    private final Map<StructureCacheEntry, Boolean> structureCache = new HashMap<StructureCacheEntry, Boolean>();

    public void clean() {
        this.structureCache.clear();
    }

    public boolean isInStructure(World world, String structure, BlockPos pos) {
        int dimension = world.field_73011_w.getDimension();
        ChunkPos cp = new ChunkPos(pos);
        long cplong = ChunkPos.func_77272_a((int)cp.field_77276_a, (int)cp.field_77275_b);
        StructureCacheEntry entry = new StructureCacheEntry(structure, dimension, cplong);
        if (this.structureCache.containsKey(entry)) {
            return this.structureCache.get(entry);
        }
        MapGenStructureData data = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, structure);
        if (data == null) {
            return false;
        }
        Set<Long> longs = StructureCache.parseStructureData(data);
        for (Long l : longs) {
            this.structureCache.put(new StructureCacheEntry(structure, dimension, l), true);
        }
        if (this.structureCache.containsKey(entry)) {
            return true;
        }
        this.structureCache.put(entry, false);
        return false;
    }

    private static Set<Long> parseStructureData(MapGenStructureData data) {
        HashSet<Long> chunks = new HashSet<Long>();
        NBTTagCompound nbttagcompound = data.func_143041_a();
        for (String s : nbttagcompound.func_150296_c()) {
            NBTTagCompound nbttagcompound1;
            NBTBase nbtbase = nbttagcompound.func_74781_a(s);
            if (nbtbase.func_74732_a() != 10 || !(nbttagcompound1 = (NBTTagCompound)nbtbase).func_74764_b("ChunkX") || !nbttagcompound1.func_74764_b("ChunkZ")) continue;
            int i = nbttagcompound1.func_74762_e("ChunkX");
            int j = nbttagcompound1.func_74762_e("ChunkZ");
            chunks.add(ChunkPos.func_77272_a((int)i, (int)j));
        }
        return chunks;
    }
}

